#ifndef __QUATERNION_H
#define __QUATERNION_H

#include "ge_matrix.h"

class Quaternion
{
	public:
		Quaternion(void);

		Real   w; // angle
		Vector v; // direction vector

		Matrix GetMatrix(void) const;			 // derive rotation matrix from quaternion
		void   SetMatrix(const Matrix &m); // derive quaternion values from matrix

		void SetAxis(const Vector &axis, Real wink); // set quaternion values directly
};

// linear interpolation between two quaternions
Quaternion Slerp(const Quaternion &q1, const Quaternion &q2, const Real alpha);

#endif
